@extends('layouts.admin')

@section('title', 'Transactions')

@section('content')
<div class="users-management">
    <div class="users-header">
        <h2>Transactions</h2>
        <div class="users-actions">
        </div>
    </div>
    
    <div class="dashboard-card">
        <div class="dashboard-card-header">
            <h3>Transaction Filters</h3>
        </div>
        <div class="dashboard-card-body">
            <form action="{{ route('admin.transactions.index') }}" method="GET" class="filter-form">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="status">Status</label>
                            <select name="status" id="status" class="form-control">
                                <option value="">All Statuses</option>
                                @foreach($statuses as $status)
                                    <option value="{{ $status }}" {{ request('status') == $status ? 'selected' : '' }}>
                                        {{ ucfirst($status) }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="user_id">User</label>
                            <select name="user_id" id="user_id" class="form-control">
                                <option value="">All Users</option>
                                @foreach($users as $id => $name)
                                    <option value="{{ $id }}" {{ request('user_id') == $id ? 'selected' : '' }}>
                                        {{ $name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="package_id">Package</label>
                            <select name="package_id" id="package_id" class="form-control">
                                <option value="">All Packages</option>
                                @foreach($packages as $id => $name)
                                    <option value="{{ $id }}" {{ request('package_id') == $id ? 'selected' : '' }}>
                                        {{ $name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="date_from">Date From</label>
                            <input type="date" name="date_from" id="date_from" class="form-control" value="{{ request('date_from') }}">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="date_to">Date To</label>
                            <input type="date" name="date_to" id="date_to" class="form-control" value="{{ request('date_to') }}">
                        </div>
                    </div>
                    <div class="col-md-6 d-flex align-items-end">
                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">Filter</button>
                            <a href="{{ route('admin.transactions.index') }}" class="btn btn-secondary">Reset</a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    
    <div class="dashboard-card mt-4">
        <div class="dashboard-card-body">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>User</th>
                            <th>Package</th>
                            <th>Amount</th>
                            <th>Status</th>
                            <th>Transaction ID</th>
                            <th>Date</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($transactions as $transaction)
                        <tr>
                            <td>
                                <a href="{{ route('admin.users.show', $transaction->user) }}">
                                    {{ $transaction->user->name }}
                                </a>
                            </td>
                            <td>{{ $transaction->package->name }}</td>
                            <td>{{ currency_symbol(config_value('store_currency', 'GBP')) }}{{ number_format($transaction->amount, 2) }}</td>
                            <td>
                                <span class="status-badge status-{{ $transaction->status }}">
                                    {{ ucfirst($transaction->status) }}
                                </span>
                            </td>
                            <td>{{ $transaction->transaction_id ?? 'N/A' }}</td>
                            <td>{{ $transaction->created_at->format('M d, Y H:i') }}</td>
                            <td class="user-actions">
                                <a href="{{ route('admin.transactions.show', $transaction) }}" class="btn-icon" title="View">
                                    <i class="fas fa-eye"></i>
                                </a>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="8" class="text-center">No transactions found.</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            <div class="pagination-container">
                {{ $transactions->appends(request()->query())->links() }}
            </div>
        </div>
    </div>
</div>
@endsection

@section('styles')
<style>
    .status-badge {
        padding: 3px 8px;
        border-radius: 4px;
        font-size: 0.8rem;
        font-weight: 500;
    }
    .status-pending {
        background-color: #f8f9fa;
        color: #6c757d;
    }
    .status-completed {
        background-color: #d4edda;
        color: #155724;
    }
    .status-failed {
        background-color: #f8d7da;
        color: #721c24;
    }
    .status-refunded {
        background-color: #e2e3e5;
        color: #383d41;
    }
    .filter-form .row {
        margin-right: -10px;
        margin-left: -10px;
    }
    .filter-form .col-md-3,
    .filter-form .col-md-6 {
        padding-right: 10px;
        padding-left: 10px;
    }
</style>
@endsection